/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.connmgr;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.connmgr.Authenticator;
import com.ibm.hwmca.fw.connmgr.ConnectionConstants;
import com.ibm.hwmca.fw.connmgr.ContextId;
import com.ibm.hwmca.fw.connmgr.InvalidPasswordException;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.util.StringUtils;
import com.ibm.hwmca.fw.util.Trace;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.net.ssl.SSLSocket;

public class HMCAuthenticator
extends Authenticator
implements ConnectionConstants {
    public static final String THIS_CLASS = "HMCAuthenticator";
    public static final String PROTOCOL_VERSION = new String("HMC 1.00");
    private static SecureRandom SECURE_RANDOM;
    static String[] ANON_SUITES;
    private String _userName = null;
    private UserContext _context = null;
    private byte[] _randomBytes;

    private static byte[] getRandomBytes(int byteSize) throws HException {
        if (SECURE_RANDOM == null) {
            SECURE_RANDOM = HMCAuthenticator.getRandomGenerator();
        }
        byte[] bytes = new byte[byteSize];
        SECURE_RANDOM.nextBytes(bytes);
        return bytes;
    }

    static void enableOnlyAnonSuites(SSLSocket socket) {
        if (ANON_SUITES == null) {
            ANON_SUITES = StringUtils.getMatches("anon", socket.getSupportedCipherSuites());
        }
        socket.setEnabledCipherSuites(ANON_SUITES);
    }

    public static SecureRandom getRandomGenerator() throws HException {
        SecureRandom randomGenerator;
        Trace.trace("HSSLCONF", "--> HMCAuthenticator.getRandomGenerator:  ");
        try {
            randomGenerator = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (Exception e) {
            for (int i = 1; i <= 10; ++i) {
                try {
                    try {
                        Trace.trace("HSSLCONF", "HMCAuthenticator.getRandomGenerator:  attempting with IBMSecureRandom and IBMJCE");
                        SecureRandom randomGenerator2 = SecureRandom.getInstance("IBMSecureRandom", "IBMJCE");
                        if (i > 1) {
                            String text = "Got a random generator on retry " + i;
                            Trace.trace("HSSLCONF", "HMCAuthenticator.getRandomGenerator:  " + text);
                        }
                        return randomGenerator2;
                    }
                    catch (NoSuchProviderException ex) {
                        throw new HException("Error creating random number generator: " + ex);
                    }
                    catch (NoSuchAlgorithmException ex) {
                        throw new HException("Error creating random number generator: " + ex);
                    }
                }
                catch (Throwable ex) {
                    Trace.trace("HSSLCONF", "HMCAuthenticator.getRandomGenerator:  failed on attempt " + i, ex);
                    Trace.trace("HSSLCONF", "HMCAuthenticator.getRandomGenerator:  pausing for 1 second");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    continue;
                }
            }
            throw new HException("Error creating random number generator, even after 10 retries!");
        }
        Trace.trace("HSSLCONF", "<-- HMCAuthenticator.getRandomGenerator:  ");
        return randomGenerator;
    }

    public HMCAuthenticator(Socket socket) throws IOException, HException {
        super(socket);
        Trace.trace("HSSLCONT", "HMCAuthenticator.java.HMCAuthenticator:  socket is " + socket);
        this._randomBytes = HMCAuthenticator.getRandomBytes(16);
    }

    public String getUserName() {
        return this._userName;
    }

    public UserContext getContext() {
        return this._context;
    }

    public boolean verifyContext(ContextId contextId) throws HException, IOException {
        Trace.trace("HSSLCONF", "--> HMCAuthenticator.verifyContext:  for context " + contextId);
        boolean result = false;
        try {
            result = this.verifyConnectionToServer(contextId.getBytes(), ConnectionConstants.CONTEXT_PASSWORD, true);
        }
        catch (InvalidPasswordException e) {
            throw new HException("Server failed to authenticate itself for context id \"" + contextId + "\".");
        }
        Trace.trace("HSSLCONF", "<-- HMCAuthenticator.verifyContext:  returning " + result);
        return result;
    }

    public boolean verifyUseridAndPassword(String userid, byte[] password) throws HException, IOException {
        Trace.trace("HSSLCONT", "--> HMCAuthenticator.java.verifyUseridAndPassword:  user=" + userid);
        this._userName = userid;
        boolean result = false;
        try {
            result = this.verifyConnectionToServer(userid.getBytes("UTF-8"), password, false);
        }
        catch (InvalidPasswordException e) {
            throw new HException("Server failed to authenticate itself for user \"" + userid + "\".");
        }
        Trace.trace("HSSLCONF", "<-- HMCAuthenticator.verifyUseridAndPassword:  returning " + result);
        return result;
    }

    private boolean verifyConnectionToServer(byte[] userToken, byte[] password, boolean contextVerify) throws InvalidPasswordException, HException, IOException {
        MessageDigest digestor;
        Trace.trace("HSSLCONF", "--> HMCAuthenticator.verifyConnectionToServer");
        HMCAuthenticator.enableOnlyAnonSuites((SSLSocket)this.socket);
        this.output = new DataOutputStream(this.socket.getOutputStream());
        this.input = new DataInputStream(this.socket.getInputStream());
        byte[] clientNonce = this._randomBytes;
        String protocol = this.input.readUTF();
        if (!protocol.equals(PROTOCOL_VERSION)) {
            this.output.writeBoolean(false);
            throw new IllegalStateException("Invalid authentication protocol:  " + protocol);
        }
        this.output.writeBoolean(true);
        byte[] serverNonce = this.readByteArray();
        try {
            digestor = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new HException("Error creating message digestor: " + e);
        }
        digestor.update(serverNonce);
        digestor.update(userToken);
        digestor.update(password);
        byte[] hashedMessage = digestor.digest();
        this.writeByteArray(clientNonce);
        this.output.writeBoolean(contextVerify);
        this.writeByteArray(userToken);
        this.writeByteArray(hashedMessage);
        this.output.flush();
        boolean authenticatedByServer = this.input.readBoolean();
        if (!authenticatedByServer) {
            return false;
        }
        byte[] serverMessage = this.readByteArray();
        digestor.update(clientNonce);
        digestor.update(userToken);
        digestor.update(password);
        hashedMessage = digestor.digest();
        if (!Arrays.equals(serverMessage, hashedMessage)) {
            this.output.writeBoolean(false);
            this.output.flush();
            throw new InvalidPasswordException();
        }
        this.output.writeBoolean(true);
        Trace.trace("HSSLCONF", "<-- HMCAuthenticator.verifyConnectionToServer:  ");
        Trace.trace("HSSLCONF", "<-- HMCAuthenticator.verifyConnectionToServer:  returning true");
        return true;
    }

    public boolean authenticateClient(Authenticator.GateKeeper gateKeeper, Authenticator.ContextKeeper contextKeeper) throws HException, IOException, InvalidPasswordException {
        MessageDigest digestor;
        Trace.trace("HSSLCONT", "--> HMCAuthenticator.java.authenticateClient:  ");
        this.output = new DataOutputStream(this.socket.getOutputStream());
        this.input = new DataInputStream(this.socket.getInputStream());
        this.output.writeUTF(PROTOCOL_VERSION);
        boolean protocolOK = this.input.readBoolean();
        if (!protocolOK) {
            throw new IllegalStateException("Client is not prepared to handle:  " + PROTOCOL_VERSION);
        }
        Trace.trace("HSSLCONF", "HMCAuthenticator.authenticateClient:  got random generator");
        byte[] serverNonce = this._randomBytes;
        Trace.trace("HSSLCONF", "HMCAuthenticator.authenticateClient:  get nextBytes from random generator");
        this.writeByteArray(serverNonce);
        this.output.flush();
        Trace.trace("HSSLCONF", "HMCAuthenticator.authenticateClient:  wrote server nonce to client");
        byte[] clientNonce = this.readByteArray();
        boolean contextVerify = this.input.readBoolean();
        byte[] userToken = this.readByteArray();
        byte[] clientMessage = this.readByteArray();
        Trace.trace("HSSLCONF", "HMCAuthenticator.authenticateClient:  read client's hashed message");
        byte[] password = null;
        if (contextVerify) {
            Trace.trace("HSSLCONF", "HMCAuthenticator.authenticateClient:  performing context verify");
            this._context = contextKeeper.getContext(new ContextId(userToken));
            if (this._context != null) {
                this._userName = this._context.getUserid();
                if (this._userName != null) {
                    password = ConnectionConstants.CONTEXT_PASSWORD;
                }
            }
        } else {
            Trace.trace("HSSLCONF", "HMCAuthenticator.authenticateClient:  performing userid/password verify");
            this._userName = new String(userToken, "UTF-8");
            password = gateKeeper.getPassword(this._userName);
        }
        if (password == null) {
            Trace.trace("HSSLCONF", "HMCAuthenticator.authenticateClient:  throwing invalid password exception");
            this.output.writeBoolean(false);
            this.output.flush();
            throw new InvalidPasswordException(this._userName);
        }
        try {
            digestor = MessageDigest.getInstance("SHA-1");
            Trace.trace("HSSLCONF", "HMCAuthenticator.authenticateClient:  got new digestor");
        }
        catch (NoSuchAlgorithmException e) {
            throw new HException("Error creating message digestor: " + e);
        }
        digestor.update(serverNonce);
        digestor.update(userToken);
        digestor.update(password);
        byte[] hashedMessage = digestor.digest();
        Trace.trace("HSSLCONF", "HMCAuthenticator.authenticateClient:  updated digestor");
        if (!Arrays.equals(clientMessage, hashedMessage)) {
            Trace.trace("HSSLCONF", "HMCAuthenticator.authenticateClient:  hashed messages disagree");
            this.output.writeBoolean(false);
            this.output.flush();
            throw new InvalidPasswordException(this._userName);
        }
        this.output.writeBoolean(true);
        digestor.update(clientNonce);
        digestor.update(userToken);
        digestor.update(password);
        hashedMessage = digestor.digest();
        Trace.trace("HSSLCONF", "HMCAuthenticator.authenticateClient:  performed 2nd digest");
        this.writeByteArray(hashedMessage);
        this.output.flush();
        Trace.trace("HSSLCONF", "HMCAuthenticator.authenticateClient:  wrote 2nd hashed message to client");
        boolean authenticatedByClient = this.input.readBoolean();
        if (!authenticatedByClient) {
            Trace.trace("HSSLCONF", "HMCAuthenticator.authenticateClient:  read boolean message from client");
            throw new InvalidPasswordException(this._userName);
        }
        Trace.trace("HSSLCONT", "<-- HMCAuthenticator.java.authenticateClient:  server authenticated client " + this._userName);
        Trace.trace("HSSLCONF", "<-- HMCAuthenticator.authenticateClient:  returning " + this._userName);
        return true;
    }

    public String toString() {
        return "HMCAuthenticator( version = " + PROTOCOL_VERSION + ", address = " + this.socket.getInetAddress() + ", port = " + this.socket.getPort() + " )";
    }

    static {
        ANON_SUITES = null;
    }
}

